VERSION 5.00
Object = "{4DE9E2A3-150F-11CF-8FBF-444553540000}#4.0#0"; "DLXOCX32.OCX"
Begin VB.Form Form1 
   Caption         =   "Form1"
   ClientHeight    =   7050
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6450
   Icon            =   "frmMain.frx":0000
   LinkTopic       =   "Form1"
   ScaleHeight     =   7050
   ScaleWidth      =   6450
   StartUpPosition =   3  'Windows Default
   Begin VB.ComboBox cboDeviceNumber 
      Height          =   315
      Left            =   2760
      TabIndex        =   11
      TabStop         =   0   'False
      Text            =   "0"
      Top             =   720
      Width           =   735
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop Paced Acquisition"
      Enabled         =   0   'False
      Height          =   375
      Left            =   480
      TabIndex        =   10
      Top             =   1920
      Width           =   2055
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   4800
      TabIndex        =   7
      Top             =   6120
      Width           =   855
   End
   Begin VB.Frame Frame1 
      Caption         =   "Select Units"
      Height          =   975
      Left            =   4320
      TabIndex        =   4
      Top             =   1080
      Width           =   1815
      Begin VB.OptionButton Option2 
         Caption         =   "Fahrenheit"
         Height          =   195
         Left            =   240
         TabIndex        =   6
         Top             =   600
         Width           =   1215
      End
      Begin VB.OptionButton optC 
         Caption         =   "Celsius"
         Height          =   255
         Left            =   240
         TabIndex        =   5
         Top             =   240
         Value           =   -1  'True
         Width           =   1095
      End
   End
   Begin DlsrLib.DriverLINXSR SR 
      Left            =   5520
      Top             =   240
      _Version        =   262144
      _ExtentX        =   741
      _ExtentY        =   741
      _StockProps     =   64
   End
   Begin VB.ListBox List1 
      Enabled         =   0   'False
      Height          =   3375
      Left            =   2880
      TabIndex        =   2
      Top             =   1440
      Width           =   1215
   End
   Begin VB.CommandButton cmdStart 
      Caption         =   "Start Paced Acquisition"
      Enabled         =   0   'False
      Height          =   375
      Left            =   480
      TabIndex        =   1
      Top             =   1320
      Width           =   2055
   End
   Begin VB.CommandButton cmdInit 
      Caption         =   "Open Driver and Init"
      Height          =   375
      Left            =   480
      TabIndex        =   0
      Top             =   720
      Width           =   2055
   End
   Begin VB.Label Label3 
      Caption         =   "Device Number :"
      BeginProperty Font 
         Name            =   "Small Fonts"
         Size            =   6.75
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   135
      Left            =   2760
      TabIndex        =   12
      Top             =   480
      Width           =   1455
   End
   Begin VB.Label Label2 
      Caption         =   $"frmMain.frx":030A
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2175
      Left            =   360
      TabIndex        =   9
      Top             =   2520
      Width           =   2175
   End
   Begin VB.Label Label1 
      AutoSize        =   -1  'True
      BackColor       =   &H000000FF&
      Caption         =   "  KEITHLEY  "
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   13.5
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H8000000E&
      Height          =   360
      Left            =   360
      TabIndex        =   8
      Top             =   120
      Width           =   1845
   End
   Begin VB.Label lblStatus 
      BackColor       =   &H8000000E&
      Caption         =   "Label1"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   615
      Left            =   360
      TabIndex        =   3
      Top             =   5160
      Width           =   4215
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim NumberofSamples As Long
'  DAS-TC/B has special gain codes for control of T/C type, averaging,
'   CJC on/off, and C or F reporting.
'   See the Analog Input Gain Codes section of the 'Using the DAS-TC/B
'   With DriverLINX ' document located in c:\driverlinx4\docs\notes\kdastc.pdf
'
'     -32768 + 5 = B Type T/C Sensor
'     -32768 + 6 = E Type T/C Sensor
'     -32768 + 7 = J Type T/C Sensor
'     -32768 + 8 = K Type T/C Sensor
'     -32768 + 9 = R Type T/C Sensor
'     -32768 + 10 = S Type T/C Sensor
'     -32768 + 11 = T Type T/C Sensor
'     -32768 + 13 = N Type T/C Sensor
'
'     1x2^13 = 8192 = CJC On
'     0x2^13 = 0 = CJC Off
'
'     1x2^14 = 16384 = report in deg F
'     0x2^14 = 0 = report in deg C
'
'     n*2^6 = n*64 = average n measurements with each reported reading
'
'
'
'  The goal of this app is to maximize the speed of acquisition from a single channel.
'  Is uses burst mode (25Hz burst rate) with an overall sample period of 1 Hz.
'  Buffers of new data will be sent each second (1 Hz), but the data contained in the
'  buffers will have been acquired at the burst rate (25Hz).
'
'  This example uses a channel/gain list to tell the driver which channels should
'  be sampled.  It happens to load the same channel and gain into each entry in
'  this list but that need not be the case.
'
' To use burst mode with DAS-TC/B, you need the driver update file applied
' else you get "number of pulses not supported" error message.

Private Sub cmdExit_Click()
Form_Unload (0)
End
End Sub

Private Sub cmdInit_Click()
    With SR
    .Req_DLL_name = "kdastc$"
    .Req_device = cboDeviceNumber.ListIndex ' index is same as value for us
    .Req_mode = DL_OTHER
    .Req_op = DL_INITIALIZE
    .Req_subsystem = DL_DEVICE
    .Refresh
    End With
    
    If SR.Res_result = DL_NoErr Then
    ' enable sample button
    cmdStart.Enabled = True
    cmdInit.Enabled = False
    lblStatus.Caption = "Initialized with " & SR.Message
    Else
    ' report on error
    lblStatus.Caption = SR.Message
    End If
    Form1.Caption = "Continuous AI with DAS-TC/B"
    Form1.SetFocus  ' return focus to the application
End Sub

Private Sub cmdStart_Click()
Dim Units As Integer
NumberofSamples = 16
List1.Clear  ' clear old data from list box
    With SR
    .Req_op = DL_START
    .Req_mode = DL_INTERRUPT
    .Req_subsystem = DL_AI
    ' specify the start and stop types
    .Evt_Str_type = DL_COMMAND  ' start when .Refresh method called
    .Evt_Stp_type = DL_COMMAND  ' stop when STOP operation carried out
    ' specify the properties that will pace our task
    .Evt_Tim_type = DL_RATEEVENT
    .Evt_Tim_rateChannel = DL_DEFAULTTIMER
    .Evt_Tim_rateClock = DL_INTERNAL1
    .Evt_Tim_rateGate = DL_NOCONNECT
    ' ratePeriod is how fast to go.....can be no faster than 2 Hz (0.5sec)
    ' can be no slower than 27.3 minutes
    .Evt_Tim_ratePeriod = .DLSecs2Tics(.Evt_Tim_rateChannel, 1) 'set for 1Hz
    ' set up burst mode
    .Evt_Tim_rateMode = DL_BURSTGEN
    .Evt_Tim_ratePulses = 16  ' must equal number of channels in the scan
    .Evt_Tim_rateOnCount = .DLSecs2Tics(.Evt_Tim_rateChannel, 0.04) 'set for 25Hz
    ' onCount is the speed of burst...can be no faster than 25 Hz
   
    If (optC.Value = True) Then
      Units = 0  ' deg C
      Else
      Units = 16384  ' deg F
    End If
    ' specify the channels
    .Sel_chan_N = 16  ' channel/gain list of 16 entries
    Dim i As Integer
    For i = 0 To 15
    .Sel_chan_list(i) = 0  ' each channel will be channel 0
    .Sel_chan_gainCodeList(i) = -32768 + 7 + 8192 + Units + (2 * 64) ' use same gain for all
                             ' type J + CJC + C or F + avg 2 per report
    ' the gain code controls TC type, CJC, Units, averaging
    Next i
    
    
    ' specify the buffering
    .Sel_buf_N = 10  ' for stop on command type tasks, uses no fewer than 3 buffers
    ' buffer size must be multiple of number of entries in chan/gain list
    .Sel_buf_samples = NumberofSamples  ' we are using 1 x chan/gain list
    
    .Sel_buf_notify = DL_NOTIFY  ' send buffer filled messages
    .Sel_chan_format = DL_tNATIVE
    .Refresh
    End With
    
    If SR.Res_result = DL_NoErr Then
    '
    lblStatus.Caption = "AI task started with " & SR.Message & _
                        "...please be patient, I am a very slow board"
    cmdStart.Enabled = False
    cmdStop.Enabled = True
    Else
    lblStatus.Caption = SR.Message
    End If
End Sub

Private Sub cmdStop_Click()
    With SR
    .Req_op = DL_STOP
    .Refresh
    End With
    lblStatus.Caption = "Task stopped by request..."
    cmdStart.Enabled = True
    cmdStop.Enabled = False
End Sub

Private Sub Form_Load()
Dim i As Integer
' populate combo box with legal values for device numbers
For i = 0 To 5
cboDeviceNumber.AddItem Str(i), i
Next i
cboDeviceNumber.ListIndex = 0  ' set it equal to first entry
End Sub

Private Sub Form_Unload(Cancel As Integer)
' stop any task that could be active
 cmdStop_Click
' unload the driver
SR.Req_DLL_name = ""
End Sub

Private Sub SR_BufferFilled(task As Integer, device As Integer, subsystem As Integer, mode As Integer, bufIndex As Integer)
Beep
Dim dummy As Single
Dim Data(100) As Single
Dim i As Integer

List1.Clear  ' clear old values
dummy = SR.VBArrayBufferConvert(bufIndex, 0, NumberofSamples, Data, DL_tSINGLE, 0, 0)
For i = 0 To NumberofSamples - 1
List1.AddItem Str(Data(i))
Next i

lblStatus.Caption = "data are here from buffer # : " & Str(bufIndex)
End Sub
